Attribute VB_Name = "mdMidPlanePart"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function MidPlane(firstGeometry As aGeometric, secondGeometry As aGeometric, workplaneName As String, sketchName As String, bNoSketch As Boolean, color As Long)

'Convenience Function to create a workplane mid-way between two planer faces or two workplanes

'check if the selected entities belong to a GeometricClass
If firstGeometry Is Nothing Then
    MsgBox ("First geometry not Selected")
Else
    Dim blnFirstGeometry As Boolean
    blnFirstGeometry = firstGeometry.IsA("Geometric")
End If

If secondGeometry Is Nothing Then
    MsgBox ("Second Edge not Selected")
Else
    Dim blnSecondGeometry As Boolean
    blnSecondGeometry = secondGeometry.IsA("Geometric")
End If

If (blnFirstGeometry And blnSecondGeometry) Then
    
    'Get the ProDESKTOP Application object
    GetApplicationObject
    
    'Get the active PartDocument
    Dim Part As PartDocument
    Set Part = app.GetActiveDoc
    
    'Get the Design
    Dim Design As aDesign
    Set Design = Part.GetDesign
    
    'Get the geometries
    Dim geom1 As zGeometry
    Dim geom2 As zGeometry
    Set geom1 = firstGeometry.GetGeometry
    Set geom2 = secondGeometry.GetGeometry
    
    Dim First As zPlane
    Dim Second As zPlane
    Set First = geom1.Clone
    Set Second = geom2.Clone
    
    'Create a zMidPlane
    Dim mid As zMidPlane
    Set mid = app.GetClass("MidPlane").CreateMidPlane(First, Second, True)
    
    'Check if a workplane of the given name already exists
    
    Dim Found As Boolean
    Found = False
    
    Dim currentWorkplane As aWorkplane
    Set currentWorkplane = Part.LookupWorkplane(workplaneName)

    If Not currentWorkplane Is Nothing Then
        Found = True
    End If

    If Found Then
        MsgBox ("A workplane already exists with that name. Choose another name")
        Set MidPlane = Nothing
        GoTo 1000
    Else
        'Create the Mid Plane
        Set MidPlane = Part.GetDesign.CreateWorkplane(mid, workplaneName)
    End If
     
    'Set the Local Origin
    Dim identity As zMatrix
    Set identity = app.GetClass("Matrix").CreateScaleMatrix(1)
    Dim box As zBox
    Set box = mid.GetBoundingBox(identity)
    bIsEmpty = box.IsEmpty()
    
    If Not bIsEmpty Then
        MidPlane.SetLocalOrigin box.GetCenter
    End If
    
    'Create a sketch with the given sketch name
    If Not bNoSketch Then
    
        Dim midPlaneSketch As aSketch
        Set midPlaneSketch = MidPlane.CreateSketch(sketchName)
        
        'Set the color for the sketch
        If color < 0 Or color > 11 Then
            color = 4
        End If
        
        Dim colorCls As ColorClass
        Dim newColor As zColor
        Set colorCls = app.GetClass("Color")
        Set newColor = colorCls.CreateColor(1, color * 30, 0.35, 1)
        
        midPlaneSketch.SetColor newColor
        Part.SetActiveSketch midPlaneSketch
    
    End If
    
Else
    
    MsgBox ("Improper Selection of Entities")
    Set MidPlane = Nothing

End If

1000:
End Function

